﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Newsletter
{
    public partial class SendNewsletters : System.Web.UI.Page
    {
        private Guid newsLetterID = Guid.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                try
                {
                    newsLetterID = Guid.Parse(Request.QueryString["UniqueID"].ToString());
                    BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue);
                }
                catch
                {
                    Response.Redirect("~/Admin/Newsletter/Newsletters.aspx", false);
                }
            }
        }

        private void BindUserList(string searchWord, DateTime fromDate, DateTime toDate)
        {
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, searchWord, fromDate, toDate);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() == "user" && pb.IsSubscribed == true && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();

            grdCustomers.DataSource = pbList;
            grdCustomers.DataBind();
        }

        protected void btnProceed_Click(object sender, EventArgs e)
        {
            NewsLetters myLetter = NewsLettersBL.GetItem(newsLetterID, string.Empty);
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (pbList != null && pbList.Count > 0)
            {
                pbList = pbList.Where(a => a.IsActive).ToList<UserAccount>();
            }
            UserAccount myUser = null;
            Guid userAccountID = Guid.Empty;
            if (radioAll.Checked)
            {
                pbList = pbList.Where(pb => pb.UserRoleType.Trim().ToLower() == "user" && pb.IsSubscribed == true).ToList<UserAccount>();

                WebSession.SendNewsLetterEmail(myLetter, myUser);
            }
            else if (radioSelected.Checked)
            {
                foreach (GridViewRow gRow in grdCustomers.Rows)
                {
                    CheckBox chkSelect = gRow.FindControl("chkSelect") as CheckBox;
                    HiddenField hdUserAccountID = gRow.FindControl("hdUserAccountID") as HiddenField;

                    if (chkSelect != null && chkSelect.Checked)
                    {
                        userAccountID = Guid.Parse(hdUserAccountID.Value);
                        myUser = pbList.Where(pb => pb.UniqueID == userAccountID).FirstOrDefault<UserAccount>();

                        WebSession.SendNewsLetterEmail(myLetter, myUser);
                    }
                }
            }

            WebUtilities.OpenNewAddEditDialog(this, "Success", "News Letter has been sent successfully.", this.ResolveClientUrl("~/Admin/NewsLetter/Newsletters.aspx"));
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/AdminsRMS/Newsletter/Newsletters.aspx", false);
        }
    }
}